<?xml version="1.0" encoding="UTF-8"?>
<!-- El objetivo de este archivo SLD, es el de simbolizar la entidad urbanística correspondiente según lo indicado en la "Instrucción técnica de estandarización y normalización de instrumentos de planeamiento (ITU-PL1)". Antes de su uso deberá revisar las etiquetas que hacen referencia a los campos existentes en las tablas de datos, especialmente los destinados a simbolizar por categorías, los de elementos alfanuméricos y los de geometría. Su definición puede admitir variantes y ser mejorada. Si es el caso, por favor, comparta su conocimiento para que futuros usuarios puedan beneficiarse. Gracias. | Murcia, mayo de 2024 | SERVICIO DE URBANISMO | https://www.urbmurcia.es/web/urbmurcia/contacto | -->
<sld:StyledLayerDescriptor xmlns="http://www.opengis.net/sld" xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" xmlns:gml="http://www.opengis.net/gml" version="1.0.0">
	<sld:NamedLayer>
		<sld:Name>05_cat_urbano</sld:Name>
		<sld:UserStyle>
			<sld:Name>05_cat_urbano</sld:Name>
			<sld:Title>05_cat_urbano</sld:Title>
			<sld:FeatureTypeStyle>
				<sld:Name>linea</sld:Name>
				<sld:Title>Categorías de suelo urbano</sld:Title>
				<sld:Abstract/>
				<sld:Rule>
					<sld:Name>linea</sld:Name>
					<sld:Title>Categoría Suelo Urbano</sld:Title>
					<sld:Abstract/>
					<sld:LineSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom2</ogc:PropertyName>
						</sld:Geometry>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#8C145A</sld:CssParameter>
							<sld:CssParameter name="stroke-width">1.5</sld:CssParameter>
							<sld:CssParameter name="stroke-dasharray">10.0 3.0 2.0 3.0 2.0 3.0</sld:CssParameter>
						</sld:Stroke>
						<sld:PerpendicularOffset>0.0</sld:PerpendicularOffset>
					</sld:LineSymbolizer>
				</sld:Rule>
			</sld:FeatureTypeStyle>
			<sld:FeatureTypeStyle>
				<sld:Name>poligono</sld:Name>
				<sld:Title/>
				<sld:Abstract/>
				<sld:Rule>
					<sld:Name>Código</sld:Name>
					<sld:Title/>
					<sld:Abstract/>
					<sld:TextSymbolizer>
						<sld:Label>
							<ogc:PropertyName>Código</ogc:PropertyName>
						</sld:Label>
						<sld:Font>
							<sld:CssParameter name="font-family">Liberation Mono</sld:CssParameter>
							<sld:CssParameter name="font-size">12</sld:CssParameter>
							<sld:CssParameter name="font-style">normal</sld:CssParameter>
							<sld:CssParameter name="font-weight">normal</sld:CssParameter>
						</sld:Font>
						<sld:LabelPlacement>
							<sld:PointPlacement>
								<sld:AnchorPoint>
									<sld:AnchorPointX>0.5</sld:AnchorPointX>
									<sld:AnchorPointY>0.5</sld:AnchorPointY>
								</sld:AnchorPoint>
								<sld:Displacement>
									<sld:DisplacementX>0.0</sld:DisplacementX>
									<sld:DisplacementY>0.0</sld:DisplacementY>
								</sld:Displacement>
							</sld:PointPlacement>
						</sld:LabelPlacement>
						<sld:Fill>
							<sld:CssParameter name="fill">#8C145A</sld:CssParameter>
						</sld:Fill>
						<sld:VendorOption name="labelAllGroup">true</sld:VendorOption>
						<sld:VendorOption name="partials">true</sld:VendorOption>
						<sld:VendorOption name="polygonAlign">mbr</sld:VendorOption>
						<sld:VendorOption name="spaceAround">10</sld:VendorOption>
					</sld:TextSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>UC</sld:Name>
					<sld:Title>(UC) Consolidado</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>UC</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<sld:PolygonSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom</ogc:PropertyName>
						</sld:Geometry>
					</sld:PolygonSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>US</sld:Name>
					<sld:Title>(US) Sin consolidar</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>US</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<sld:PolygonSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom</ogc:PropertyName>
						</sld:Geometry>
					</sld:PolygonSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>UR</sld:Name>
					<sld:Title>(UR) Rural</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>UR</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<sld:PolygonSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom</ogc:PropertyName>
						</sld:Geometry>
					</sld:PolygonSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>UE</sld:Name>
					<sld:Title>(UE) Especial</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>UE</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<sld:PolygonSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom</ogc:PropertyName>
						</sld:Geometry>
					</sld:PolygonSymbolizer>
				</sld:Rule>
			</sld:FeatureTypeStyle>
		</sld:UserStyle>
	</sld:NamedLayer>
</sld:StyledLayerDescriptor>